unit ExtraItem_u;

interface

uses SysUtils;

Type
  TExtraItems = class
  private
    iGuestNum: Integer;
    sItemType: String;
    rCost: Real;

  public
    constructor Create(iGuestNum: Integer; sItemType: String; rCost: Real);
    function getGuestNumber: Integer;
    function calculateProfit: Real;
    function calculatePrice: Real;
    function toString: String;
  end;

implementation

{ TExtraItems }

function TExtraItems.calculatePrice: Real;
  begin
    Result := rCost + calculateProfit;
  end;

function TExtraItems.calculateProfit: Real;
  begin
    Result := rCost * 25/100;
  end;

constructor TExtraItems.Create(iGuestNum: Integer; sItemType: String;
  rCost: Real);
  begin
    Self.iGuestNum := iGuestNum;
    Self.sItemType := sItemType;
    Self.rCost := rCost;
  end;

function TExtraItems.getGuestNumber: Integer;
  begin
    Result := iGuestNum;
  end;

function TExtraItems.toString: String;
  var
    sOutput: String;
  begin
    sOutput := sItemType + #9 + FloatToStrF(rCost, ffCurrency, 8, 2)
      + #9 + FloatToStrF(calculateProfit, ffCurrency, 8, 2) + #9 + FloatToStrF
      (calculatePrice, ffCurrency, 8, 2);
    Result := sOutput;
  end;

end.
